<?php
  /**
   * Functions
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: functions.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('. دسترسی مستقیم به این محل مجاز نمی باشد');
  
  /**
   * redirect_to()
   * 
   * @param mixed $location
   * @return
   */
  function redirect_to($location)
  {
      if (!headers_sent()) {
          header('Location: ' . $location);
		  exit;
	  } else
          echo '<script type="text/javascript">';
          echo 'window.location.href="' . $location . '";';
          echo '</script>';
          echo '<noscript>';
          echo '<meta http-equiv="refresh" content="0;url=' . $location . '" />';
          echo '</noscript>';
  }
  
  /**
   * countEntries()
   * 
   * @param mixed $table
   * @param string $where
   * @param string $what
   * @return
   */
  function countEntries($table, $where = '', $what = '')
  {
      global $db;
      if (!empty($where) && isset($what)) {
          $q = "SELECT COUNT(*) FROM " . $table . "  WHERE " . $where . " = '" . $what . "' LIMIT 1";
      } else
          $q = "SELECT COUNT(*) FROM " . $table . " LIMIT 1";
      
      $record = $db->query($q);
      $total = $db->fetchrow($record);
      return $total[0];
  }
  
  /**
   * getChecked()
   * 
   * @param mixed $row
   * @param mixed $status
   * @return
   */
  function getChecked($row, $status)
  {
      if ($row == $status) {
          echo "checked=\"checked\"";
      }
  }
  
  /**
   * post()
   * 
   * @param mixed $var
   * @return
   */
  function post($var)
  {
      if (isset($_POST[$var]))
          return $_POST[$var];
  }
  
  /**
   * get()
   * 
   * @param mixed $var
   * @return
   */
  function get($var)
  {
      if (isset($_GET[$var]))
          return $_GET[$var];
  }
  
  /**
   * sanitize()
   * 
   * @param mixed $string
   * @param bool $trim
   * @return
   */
  function sanitize($string, $trim = false,  $end_char = '&#8230;', $int = false, $str = false)
  {
      $string = filter_var($string, FILTER_SANITIZE_STRING);
      $string = trim($string);
      $string = stripslashes($string);
      $string = strip_tags($string);
      $string = str_replace(array('‘', '’', '“', '”'), array("'", "'", '"', '"'), $string);
      
	  if ($trim) {
        if (strlen($string) < $trim)
        {
            return $string;
        }

        $string = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $string));

        if (strlen($string) <= $trim)
        {
            return $string;
        }

        $out = "";
        foreach (explode(' ', trim($string)) as $val)
        {
            $out .= $val.' ';

            if (strlen($out) >= $trim)
            {
                $out = trim($out);
                return (strlen($out) == strlen($string)) ? $out : $out.$end_char;
            }       
        }
		  
          //$string = substr($string, 0, $trim);
		  
	  }
      if ($int)
		  $string = preg_replace("/[^0-9\s]/", "", $string);
      if ($str)
		  $string = preg_replace("/[^a-zA-Z\s]/", "", $string);
		  
      return $string;
  }
    
  /**
   * getValue()
   * 
   * @param mixed $stwhatring
   * @param mixed $table
   * @param mixed $where
   * @return
   */
  function getValue($what, $table, $where)
  {
      global $db;
      $sql = "SELECT $what FROM $table WHERE $where";
      $row = $db->first($sql);
      return $row[$what];
  }  
  
  /**
   * tooltip()
   * 
   * @param mixed $tip
   * @return
   */
  function tooltip($tip)
  {
      return '<img src="'.ADMINURL.'/images/tooltip.png" alt="Tip" class="tooltip" title="' . $tip . '" />';
  }
  
  /**
   * required()
   * 
   * @return
   */
  function required()
  {
      return '<img src="'.ADMINURL.'/images/required.png" alt="موارد اجبـاری" class="tooltip" title="موارد اجبـاری" />';
  }

  /**
   * cleanOut()
   * 
   * @param mixed $text
   * @return
   */
  function cleanOut($text) {
	 $text =  strtr($text, array('\r\n' => "", '\r' => "", '\n' => ""));
	 $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
	 $text = str_replace('<br>', '<br />', $text);
	 return stripslashes($text);
  }
    

  /**
   * isAdmin()
   * 
   * @param mixed $userlevel
   * @return
   */
  function isAdmin($userlevel)
  {
	  switch ($userlevel) {
		  case 9:
		     $display = '<img src="'.SITEURL.'/images/superadmin.png" alt="" class="tooltip" title="مـدیـر"/>';
			 break;

		  case 7:
		     $display = '<img src="'.SITEURL.'/images/level7.png" alt="" class="tooltip" title="سطـح کاربـر 7"/>';
			 break;

		  case 6:
		     $display = '<img src="'.SITEURL.'/images/level6.png" alt="" class="tooltip" title="سطـح کاربـر 6"/>';
			 break;

		  case 5:
		     $display = '<img src="'.SITEURL.'/images/level5.png" alt="" class="tooltip" title="سطـح کاربـر 5"/>';
			 break;
			 
		  case 4:
		     $display = '<img src="'.SITEURL.'/images/level4.png" alt="" class="tooltip" title="سطـح کاربـر 4"/>';
			 break;		  

		  case 3:
		     $display = '<img src="'.SITEURL.'/images/level6.png" alt="" class="tooltip" title="سطـح کاربـر 3"/>';
			 break;

		  case 2:
		     $display = '<img src="'.SITEURL.'/images/level5.png" alt="" class="tooltip" title="سطـح کاربـر 2"/>';
			 break;
			 
		  case 1:
		     $display = '<img src="'.SITEURL.'/images/user.png" alt="" class="tooltip" title="کـاربـر"/>';
			 break;			  
	  }

      return $display;;
  }

  /**
   * userStatus()
   * 
   * @param mixed $id
   * @return
   */
  function userStatus($status)
  {
	  switch ($status) {
		  case "y":
			  $display = '<img src="images/u_active.png" alt="" class="tooltip" title="کـاربـر فـعـال"/>';
			  break;
			  
		  case "n":
			  $display = '<img src="images/u_inactive.png" alt="" class="tooltip" title="کـاربـر غیـر فعـال"/>';
			  break;
			  
		  case "t":
			  $display = '<img src="images/u_pending.png" alt="" class="tooltip" title="کـاربـر منتـظـر"/>';
			  break;
			  
		  case "b":
			  $display = '<img src="images/u_banned.png" alt="" class="tooltip" title="کـاربـر توقیـف شـده"/>';
			  break;
	  }
	  
      return $display;;
  }

  /**
   * isActive()
   * 
   * @param mixed $id
   * @return
   */
  function isActive($id)
  {
	  if ($id == 1) {
		  $display = '<img src="images/yes.png" alt="" class="tooltip img-wrap2" title="فـعـال"/>';
	  } else {
		  $display = '<img src="images/no.png" alt="" class="tooltip img-wrap2" title="غیـر فـعـال"/>';
	  }

      return $display;;
  }

  /**
   * createPageLink()
   * 
   * @param mixed $id
   * @return
   */
  function createPageLink($id)
  {
      global $db, $core;
      
      $row = $db->first("SELECT id, slug FROM pages WHERE id = '".(int)$id."'");
      
      if ($core->seo == 1) {
          $display = $core->site_url . '/view-content/' . intval($row['id']) . '/' . sanitize($row['slug']) . '.html';
      } else {
          $display = $core->site_url . '/content.php?id=' . intval($row['id']);
      }
      return $display;
  }

  /**
   * createCategoryLink()
   * 
   * @param mixed $id
   * @return
   */
  function createCategoryLink($id)
  {
      global $db, $core;
      
      $row = $db->first("SELECT id, slug FROM categories WHERE id = '".(int)$id."'");
      
      if ($core->seo == 1) {
          $display = $core->site_url . '/category/' . intval($row['id']) . '/' . sanitize($row['slug']) . '.html';
      } else {
          $display = $core->site_url . '/category.php?cid=' . intval($row['id']);
      }
      return $display;
  }

  /**
   * createProductLink()
   * 
   * @param mixed $id
   * @return
   */
  function createProductLink($id)
  {
      global $db, $core;
      
      $row = $db->first("SELECT id, slug FROM products WHERE id = '".(int)$id."'");
      
      if ($core->seo == 1) {
          $display = $core->site_url . '/view-item/' . intval($row['id']) . '/' . sanitize($row['slug']) . '.html';
      } else {
          $display = $core->site_url . '/item.php?pid=' . intval($row['id']);
      }
      return $display;
  }
    

  /**
   * getSize()
   * 
   * @param mixed $size
   * @param integer $precision
   * @param bool $long_name
   * @param bool $real_size
   * @return
   */
  function getSize($size, $precision = 2, $long_name = false, $real_size = true)
  {
	  $base = $real_size ? 1024 : 1000;
	  $pos = 0;
	  while ($size > $base) {
		  $size /= $base;
		  $pos++;
	  }
	  $prefix = _getSizePrefix($pos);
	  @$size_name = ($long_name) ? $prefix . "bytes" : $prefix[0] . "B";
	  return round($size, $precision) . ' ' . ucfirst($size_name);
  }
  
  /**
   * _getSizePrefix()
   * 
   * @param mixed $pos
   * @return
   */
  function _getSizePrefix($pos)
  {
	  switch ($pos) {
		  case 00:
			  return "";
		  case 01:
			  return "kilo";
		  case 02:
			  return "mega";
		  case 03:
			  return "giga";
		  default:
			  return "?-";
	  }
  }
	    
  /**
   * randName()
   * 
   * @return
   */ 
  function randName() {
	  $code = '';
	  for($x = 0; $x<6; $x++) {
		  $code .= '-'.substr(strtoupper(sha1(rand(0,999999999999999))),2,6);
	  }
	  $code = substr($code,1);
	  return $code;
  }
?>